<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2025-05-13 00:19
 */
interface SliderDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Slider 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param slider primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Slider slider
 	 */
	public function insert($slider);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Slider slider
 	 */
	public function update($slider);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTitle($value);

	public function queryByTitleEn($value);

	public function queryByTitleUrl($value);

	public function queryByOpenTarget($value);

	public function queryByMediaUrl($value);

	public function queryByMediaType($value);

	public function queryByDescription($value);

	public function queryByDescriptionEn($value);

	public function queryByPosition($value);

	public function queryByIsActive($value);

	public function queryBySysDate($value);

	public function queryByUserid($value);

	public function queryByIsdel($value);


	public function deleteByTitle($value);

	public function deleteByTitleEn($value);

	public function deleteByTitleUrl($value);

	public function deleteByOpenTarget($value);

	public function deleteByMediaUrl($value);

	public function deleteByMediaType($value);

	public function deleteByDescription($value);

	public function deleteByDescriptionEn($value);

	public function deleteByPosition($value);

	public function deleteByIsActive($value);

	public function deleteBySysDate($value);

	public function deleteByUserid($value);

	public function deleteByIsdel($value);


}
?>